// ==UserScript==
// @name         5ch 別スレッドURLポップアップ対応
// @namespace    http://tampermonkey.net/
// @version      1.0
// @description  他スレの5ch read.cgi形式URLのリンクにマウスホバーでレスポップアップを表示する
// @author       ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-idle
// ==/UserScript==

(function() {
    'use strict';

    let currentPopupId = null;
    let popupTimeout = null;

    function showPopup($elem, resId, html) {
        removePopup();

        const $popup = $('<div id="reply-' + resId + '" class="post_hover" data-ha="' + resId + '">' + html + '</div>');
        $popup.css({
            border: "1px solid #333",
            position: "absolute",
            backgroundColor: "rgb(239,239,239)",
            display: "block",
            padding: "5px",
            zIndex: 9999,
            maxWidth: "500px",
            overflowWrap: "break-word"
        });
        $("body").append($popup);

        const offset = $elem.offset();
        const popupWidth = $popup.outerWidth(true);
        const popupHeight = $popup.outerHeight(true);
        let left = offset.left + $elem.outerWidth();
        if (left + popupWidth > $(window).width()) {
            left = offset.left - popupWidth;
            if (left < 0) left = 0;
        }
        let top = offset.top - 10;
        const scrollTop = $(window).scrollTop();
        if (top < scrollTop) top = scrollTop;
        if (top + popupHeight > scrollTop + $(window).height()) {
            top = scrollTop + $(window).height() - popupHeight - 10;
        }

        $popup.css({left: left, top: top}).fadeIn("fast");

        currentPopupId = resId;

        $popup.on('mouseenter', function() {
            clearTimeout(popupTimeout);
        }).on('mouseleave', function() {
            removePopup();
        });
    }

    function removePopup() {
        $('.post_hover').remove();
        currentPopupId = null;
        clearTimeout(popupTimeout);
    }

    $(document).on('mouseenter', 'a[href]', function() {
        const $this = $(this);
        const href = $this.attr('href');
        if (!href) return;

        // 5ch read.cgi形式URLを正規表現で取得（ドメイン、板名、スレID、レスID）
        // URL例: https://greta.5ch.net/test/read.cgi/poverty/1748750500/32
        let m = href.match(/^https?:\/\/([^\/]+)\/test\/read\.cgi\/([^\/]+)\/(\d+)(?:\/(\d+))?\/?$/);
        if (!m) return;

        const domain = m[1]; // ドメイン
        const board = m[2]; // サーバー（板）
        const threadId = m[3]; // スレッドID
        const resId = m[4] || '1'; // レス番号

        if (currentPopupId === resId) return;

        const ajaxUrl = `https://${domain}/test/read.cgi/${board}/${threadId}/`;

        $.ajax({
            url: ajaxUrl,
            dataType: "text",
            cache: false,
            success: function(data) {
                const $doc = $('<div></div>').append($.parseHTML(data));
                const $post = $doc.find('#' + resId);
                if ($post.length === 0) return;

                const threadTitle = $doc.find('#threadtitle').text().trim();

                $post.find('.message .hoverAppend, .back-links .hoverAppend').remove();

                const popupHtml = `<div style="font-weight:bold; margin-bottom:5px;">${threadTitle}</div>` + $post.html();

                showPopup($this, resId, popupHtml);
            },
            error: function() {
                // 失敗時は何もしない
            }
        });
    });

    $(document).on('mouseleave', 'a[href]', function() {
        if (popupTimeout) clearTimeout(popupTimeout);
        popupTimeout = setTimeout(removePopup, 300);
    });
})();
